package com.example.sefinsa_app.ui.pagos;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.HorizontalScroll;
import com.example.sefinsa_app.utilities.PagosAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VerticalScroll;
import com.example.sefinsa_app.utilities.VolleyMultipartRequest;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PagosFragment extends Fragment implements HorizontalScroll.ScrollViewListener, VerticalScroll.ScrollViewListener{

    private PagosViewModel mViewModel;

    private ArrayList<Pago> pagos, pagosFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;

    Button btnPagar, btnPagarConMulta, btnNoPagar;

    private SearchView svPagos;
    private RecyclerView recyclerViewInfo, recyclerViewNombre0, recyclerViewPagos;
    //private RegistroCreditoAdapter registroCreditoAdapter;
    private ShimmerFrameLayout shimmer;
    private PagosAdapter pagosAdapter;
    private LinearLayoutManager linearLayoutManager;

    private TextView informacionPrestamo;

    private Pago pagoSeleccionado;

    public String prestramoJsonString;
    public Prestamo prestamo;

    private ArrayList<PagosHechos> pagosHechos;

    private SharedPreferences sesion;

    private ArrayList<Prestamo> prestamosFiltrados;


    public static PagosFragment newInstance() {
        return new PagosFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {

       /* Activity a = getActivity();
        if(a != null) a.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);*/

        return inflater.inflate(R.layout.fragment_pagos, container, false);
    }


    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        CurrentFragment.fragment = "PagosFragment";
        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);


        Bundle args = getArguments();
        prestramoJsonString = args.getString("prestamo");
        prestamo = Utils.getGsonParser().fromJson(prestramoJsonString, Prestamo.class);
        prestamosFiltrados = args.getParcelableArrayList("lista_filtrada");

        Log.d("LISTA", prestamosFiltrados.toString());

        shimmer = view.findViewById(R.id.sfPagos);
        informacionPrestamo = view.findViewById(R.id.informacionPrestamo);

        informacionPrestamo.setText(prestamo.getNombre_completo() + " (" + prestamo.getNumero_tarjeton() +")");


      //  Toast.makeText(getActivity(), prestamo.getId(), Toast.LENGTH_SHORT).show();

        recyclerViewPagos = view.findViewById(R.id.rvPagos);
        pagos = new ArrayList<Pago>();

        getPagos(prestamo.getId());


        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerViewPagos.setLayoutManager(linearLayoutManager);
        pagosAdapter = new PagosAdapter(getActivity(), pagos, prestamo);
        recyclerViewPagos.setAdapter(pagosAdapter);
        recyclerViewPagos.getRecycledViewPool().setMaxRecycledViews(0, 0);

        btnPagar = view.findViewById(R.id.btnPagar);
        btnPagarConMulta = view.findViewById(R.id.btnPagarConMulta);
        btnNoPagar = view.findViewById(R.id.btnNoPagar);

        btnPagar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                for(Pago pago: pagos){
                    if(pago.getStatus().equals("0")){
                        pagoSeleccionado = pago;
                        break;
                    }
                }

                if(pagoSeleccionado != null) {
                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Pagar Semana " + pagoSeleccionado.getSemana())
                            .setMessage("Se aplicara un pago de $" + pagoSeleccionado.getCantidad_esperada_pago())
                            .setPositiveButton("Pagar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {

                                    pagar(pagoSeleccionado.getPrestamo_id(), pagoSeleccionado.getSemana(), pagoSeleccionado.getTipo_pago());

                                }
                            })
                            .show();
                }
            }
        });

        btnPagarConMulta.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                for(Pago pago: pagos){
                    if(pago.getStatus().equals("0")){
                        pagoSeleccionado = pago;
                        break;
                    }
                }

                if(pagoSeleccionado != null){
                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Pagar Semana " + pagoSeleccionado.getSemana())
                            .setMessage("Se aplicara un pago de $" + pagoSeleccionado.getCantidad_esperada_pago()
                                    + " con una multa de $" + pagoSeleccionado.getMonto_multa() )
                            .setPositiveButton("Pagar con multa", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                    pagarConMulta(pagoSeleccionado.getPrestamo_id(), pagoSeleccionado.getSemana(), pagoSeleccionado.getTipo_pago());
                                }
                            })
                            .show();
                }

            }
        });

        btnNoPagar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                for(Pago pago: pagos){
                    if(pago.getStatus().equals("0")){
                        pagoSeleccionado = pago;
                        break;
                    }
                }

                if(pagoSeleccionado != null) {
                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Semana " + pagoSeleccionado.getSemana())
                            .setMessage("Se marcara la semana como No pagada")
                            .setPositiveButton("No pagar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                    noPagar(pagoSeleccionado.getPrestamo_id(), pagoSeleccionado.getSemana());
                                }
                            })
                            .show();
                }
            }
        });



        /*recyclerViewInfo = view.findViewById(R.id.rvInfo);
        recyclerViewNombres = view.findViewById(R.id.rvNombres);
        svPagos = view.findViewById(R.id.svPagos);
        pagos = new ArrayList<RegistroCredito>();

        getPagos();

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerViewInfo.setLayoutManager(linearLayoutManager);
        registroCreditoAdapter = new RegistroCreditoAdapter(getActivity(), pagos);
        recyclerViewInfo.setAdapter(registroCreditoAdapter );*/

        /*recyclerViewInfo.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

                if (!recyclerView.canScrollVertically(1) && newState == RecyclerView.SCROLL_STATE_IDLE) {
                    //reached end
                }

                if (!recyclerView.canScrollVertically(-1) && newState == RecyclerView.SCROLL_STATE_IDLE) {
                    //reached top
                }
                if(newState == RecyclerView.SCROLL_STATE_DRAGGING){
                    //scrolling
                }

            }
        });*/

        /*recyclerViewInfo.addOnItemTouchListener(new RecyclerView.OnItemTouchListener() {

            private int mLastY;

            @Override
            public boolean onInterceptTouchEvent(@NonNull final RecyclerView rv, @NonNull final
            MotionEvent e) {
                Log.d("debug", "LEFT: onInterceptTouchEvent");

                final Boolean ret = rv.getScrollState() != RecyclerView.SCROLL_STATE_IDLE;
                if (!ret) {
                    onTouchEvent(rv, e);
                }
                return Boolean.FALSE;
            }

            @Override
            public void onTouchEvent(@NonNull final RecyclerView rv, @NonNull final MotionEvent e) {
                Log.d("debug", "LEFT: onTouchEvent");

                final int action;
                if ((action = e.getAction()) == MotionEvent.ACTION_DOWN && mRightRecyclerView
                        .getScrollState() == RecyclerView.SCROLL_STATE_IDLE) {
                    mLastY = rv.getScrollY();
                    rv.addOnScrollListener(mLeftOSL);
                }
                else {
                    if (action == MotionEvent.ACTION_UP && rv.getScrollY() == mLastY) {
                        rv.removeOnScrollListener(mLeftOSL);
                    }
                }
            }

            @Override
            public void onRequestDisallowInterceptTouchEvent(final boolean disallowIntercept) {
                Log.d("debug", "LEFT: onRequestDisallowInterceptTouchEvent");
            }
        });*/

        /*mRightRecyclerView.addOnItemTouchListener(new RecyclerView.OnItemTouchListener() {

            private int mLastY;

            @Override
            public boolean onInterceptTouchEvent(@NonNull final RecyclerView rv, @NonNull final
            MotionEvent e) {
                Log.d("debug", "RIGHT: onInterceptTouchEvent");

                final Boolean ret = rv.getScrollState() != RecyclerView.SCROLL_STATE_IDLE;
                if (!ret) {
                    onTouchEvent(rv, e);
                }
                return Boolean.FALSE;
            }

            @Override
            public void onTouchEvent(@NonNull final RecyclerView rv, @NonNull final MotionEvent e) {
                Log.d("debug", "RIGHT: onTouchEvent");

                final int action;
                if ((action = e.getAction()) == MotionEvent.ACTION_DOWN && mLeftRecyclerView
                        .getScrollState
                                () == RecyclerView.SCROLL_STATE_IDLE) {
                    mLastY = rv.getScrollY();
                    rv.addOnScrollListener(mRightOSL);
                }
                else {
                    if (action == MotionEvent.ACTION_UP && rv.getScrollY() == mLastY) {
                        rv.removeOnScrollListener(mRightOSL);
                    }
                }
            }

            @Override
            public void onRequestDisallowInterceptTouchEvent(final boolean disallowIntercept) {
                Log.d("debug", "RIGHT: onRequestDisallowInterceptTouchEvent");
            }
        });*/

    }

    private void getPagos(String prestamo_id)
    {
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "pagosPrestamo");
            data.put("prestamo_id", prestamo_id);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            dialog.cancel();

                            JSONArray data = (JSONArray) response.get("data");

                            pagosAdapter.clear();
                            pagos.clear();

                            for(int i = 0; i < data.length(); i++){

                                JSONObject obj = data.getJSONObject(i);

                                Gson gson = new Gson();
                                Pago pago = gson.fromJson(obj.toString(), Pago.class);

                                pagos.add(pago);

                            }


                            pagosAdapter.addAll(pagos);
                            pagosAdapter.notifyItemRangeChanged(pagos.size(), 1);

                            shimmer.startShimmer();
                            shimmer.setVisibility(View.GONE);
                            recyclerViewPagos.setVisibility(View.VISIBLE);


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }


                        // Toast.makeText(this, "nada", Toast.LENGTH_LONG).show();
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                dialog.cancel();
                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);



    }

    private void pagar(String prestamo_id, String semana, String tipo_pago)
    {
        VolleyS vs = VolleyS.getInstance(getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "pagarSiguiente");
            data.put("prestamo_id", prestamo_id);
            data.put("semana", semana);
            data.put("empleado_id", sesion.getString("id", "0"));
            data.put("tipo_pago", tipo_pago);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            String data = response.get("status").toString();

                            Date c = Calendar.getInstance().getTime();
                            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                            String formattedDate = df.format(c);

                            PagosHechos pagoHecho = new PagosHechos(
                                    formattedDate,
                                    prestamo.getNombre_poblacion(),
                                    prestamo.getNombre_completo(),
                                    prestamo.getPago_semanal(),
                                    sesion.getString("nombre_perfil", ""),
                                    prestamo.getMonto_multa(),
                                    prestamo.getNombre_ruta()
                            );


                            if(data.equals("success")){
                                getPagos(prestamo.getId());
                                //Toast.makeText(getActivity(), "Pago realizado", Toast.LENGTH_SHORT).show();
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());


            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }

    private void pagarConMulta(String prestamo_id, String semana, String tipo_pago)
    {
        VolleyS vs = VolleyS.getInstance(getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "pagarSiguienteConMulta");
            data.put("prestamo_id", prestamo_id);
            data.put("semana", semana);
            data.put("empleado_id", sesion.getString("id", "0"));
            data.put("tipo_pago", tipo_pago);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            String data = response.get("status").toString();

                            Date c = Calendar.getInstance().getTime();
                            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                            String formattedDate = df.format(c);

                            PagosHechos pagoHecho = new PagosHechos(
                                    formattedDate,
                                    prestamo.getNombre_poblacion(),
                                    prestamo.getNombre_completo(),
                                    String.valueOf(Utils.convertirDouble(prestamo.getPago_semanal())),
                                    sesion.getString("nombre_perfil", ""),
                                    prestamo.getMonto_multa(),
                                    prestamo.getNombre_ruta()
                            );


                            if(data.equals("success")){
                                getPagos(prestamo.getId());
                                //Toast.makeText(getActivity(), "Pago realizado", Toast.LENGTH_SHORT).show();
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }

    private void noPagar(String prestamo_id, String semana)
    {
        VolleyS vs = VolleyS.getInstance(getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "noPagarSiguiente");
            data.put("prestamo_id", prestamo_id);
            data.put("semana", semana);
            data.put("empleado_id", sesion.getString("id", "0"));

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            String data = response.get("status").toString();

                            if(data.equals("success")){
                                getPagos(prestamo.getId());
                                Toast.makeText(getActivity(), "Pago no recibido", Toast.LENGTH_SHORT).show();
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));


        request.setShouldCache(false);
        requestQueue.add(request);

    }



    private void pagos2()
    {

        /*ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppCompatAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();*/

        VolleyMultipartRequest volleyMultipartRequest = new VolleyMultipartRequest(Request.Method.POST, API.urlPagos,
                new Response.Listener<NetworkResponse>() {
                    @Override
                    public void onResponse(NetworkResponse response) {
                        try {
                            JSONObject obj = new JSONObject(new String(response.data));
                            String status = obj.get("status").toString();
                            if(status.equals("success")){

                                //Toast.makeText(getActivity(), obj.toString(), Toast.LENGTH_SHORT).show();

                            }


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        ErrorChecker.checker(error, getActivity());
                    }
                }) {


            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<>();
                params.put("func", "reporteRegistroCredito");
                params.put("modalidad", "2");
                return params;
            }


        };

        //adding the request to volley
        Volley.newRequestQueue(getActivity()).add(volleyMultipartRequest);
    }


    @Override
    public void onScrollChanged(HorizontalScroll scrollView, int x, int y, int oldx, int oldy) {

    }

    @Override
    public void onScrollChanged(VerticalScroll scrollView, int x, int y, int oldx, int oldy) {

    }
}